package org.lsst.ccs.bus.messages;

/**
 * Log message to be sent on Log bus.
 * The contained information is independent of the Logging implementation.
 * Each LogMessage has an embedded String object representing the message to be
 * sent over the buses. This String is the formatted version of the provided
 * log message.
 * The encoding process just returns null. So the embedded and
 * encoded objects are the same.
 * Additional information contained in each LogMessage:
 * <ul>
 *  <li>The formatted version of the original log message</li>
 *  <li>The name of the thread on which the message originated</li>
 *  <li>The name of the logger from which the message was sent</li>
 *  <li>The name of the source that originated the message. This is
 * the name of the class followed by the method from which the message was sent</li>
 *  <li>The log level of the LogMessage</li>
 * </ul>
 * 
 * @author The LSST CCS Team.
 * 
 */
public class LogMessage extends BusMessage<String,String> {
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -4194787513329636909L;

    private final String threadName;
    private final String loggerName;    
    private final String sourceName;    
    private final String level;

    /**
     * LogMessage constructor.
     * @param threadName the name of the thread from which the LogMessage was created
     * @param loggerName the name of the logger which issued the log
     * @param sourceName concatenation of the form ClassName#methodName
     * @param formattedDetails a formatted  String that represents the Log record (can be text or xml)
     *                         it is dependent on the <TT>Formatter</TT> of the Handler.
     * @param level A string representing the Level
     */
    public LogMessage(String threadName, String loggerName, String sourceName, String formattedDetails, String level) {
        super(formattedDetails);
        this.threadName = threadName;
        this.loggerName = loggerName;
        this.sourceName = sourceName;
        this.level = level;
    }

    @Override
    protected String encodeObject(String obj) {
        return null;
    }      

    @Override
    public String getEncodedData() {
        return super.getObject();
    }    
    
    /**
     * Get the name of the thread on which the LogMessage originated.
     * @return The original thread name.
     * 
     */
    public String getThreadName() {
        return threadName;
    }

    /**
     * Get the name of the logger used to record the LogMessage.
     * @return The name of the logger.
     * 
     */
    public String getLoggerName() {
        return loggerName;
    }

    /**
     * Get the source of the LogMessage.
     * @return The name of the LogMessage source. By default this is
     *         ClassName#Method
     * 
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * The formatted version of the logged message.
     * @return The formatted version of the loggged message.
     * 
     */
    public String getFormattedDetails() {
        return getObject();
    }

    /**
     * The level (or severity) of the LogMessage.
     * @return The level of the LogMessage.
     * 
     */
    public String getLevel() {
        return level;
    }


    /**
     * returns the "formatted details"
     * @return
     */
    @Override
    public String toString() {
        return getObject();
    }
}
