package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.utils.EncodingUtils;

/**
 * Status with additional information.
 * Instances of this class carry a set of data with a common <TT>dataTimeStamp</TT>.
 * Each data in this set (of type <TT>KVList</TT>) is an object with a name.
 * Each object is encoded in a <TT>KeyData</TT> structure.
 * <P/>
 * Note: keep in mind that each element in the list is of the form <TT>Key-VALUE</TT>
 * but the <TT>VALUE</TT>   can be itself burst into a list of
 * key-values (if it is a composite Object) (so do not confuse the keys!)
 * <P/>
 * So for example you can have
 * <UL>
 *     <LI/> a single primitive value contained as <TT>KVList{KeyData{"MyInteger",666}}</TT>
 *     <LI/> multiple primitive values contained as <TT>KVList{KeyData{"MyInteger",666}, KeyData{"MyString, "Hello"}}</TT>
 *     <LI/> single or multiple values that can be of any type (composite objects should have some specific properties: be <TT>Serializable</TT> or be "decomposable" in a list of key-value pairs) as:
 *     <TT>KVList{KeyData{"MyInteger", 666}, i
 *     KeyData{"MyObject", CodedData{"org.lsst.ccs.MyType", ,
 *     List{KeyData{"field1", 567}, KeyData{"field2", "world"}}}}}</TT>
 *     (in that case objects of type <TT>MyType</TT> have two fields: "field1" and "field2")
 *     <BR/> the important thing here is that the object will be read as <TT>
 *         List{"MyObject.field1"=567, "MyObject.field2"="world"}
 *     </TT>
 * </UL>
 * Methods encapsulate and simplify this analysis:
 * for reading <TT>KeyData</TT> objects see corresponding documentation.
 * <P/>
 * Instances of the current class can be "linked" together to be sent in a single message
 * across the buses. This is used when one wants to publish different values with different timestamps
 * in a same message.
 *
 * @author bamade
 */
// Date: 15/04/13
@Deprecated
public class EncodedDataStatus extends StatusSubsystemData implements Iterable<EncodedDataStatus> {


    private static final long serialVersionUID = 3510287510951431305L;
    private EncodedDataStatus nextStatus;
    private final long dataTimeStamp;
    private String key = "";

    /**
     * creates a status with a list of Key-value pairs with the same timestamp
     *
     * @param timestampArg
     * @param content
     */
    @Deprecated
    public EncodedDataStatus(long timestampArg, KVList content) {
        super(content,null);
        this.dataTimeStamp = timestampArg;
    }

    /**
     * creates a status with a list of Key-value pairs with the same timestamp
     * which is generated at creation time.
     * @param content
     */
    @Deprecated
    public EncodedDataStatus(KVList content) {
        this(System.currentTimeMillis(), content);
    }

    /**
     * creates a status with a single key and value (the timestamp is also provided)
     * @param timestamp
     * @param key
     * @param value
     */
    @Deprecated
    public EncodedDataStatus(long timestamp, String key, Object value) {
        super((Serializable)value,null);
        this.dataTimeStamp = timestamp;
        this.key = key;
    }

    /**
     * creates a status with a single key and value (the timestamp is generated)
     * @param key
     * @param value
     */
    @Deprecated
    public EncodedDataStatus(String key, Object value) {
        this(System.currentTimeMillis(),key, value);
    }

    /**
     * adds another status at the end of the linked list of status sent in a single message
     * @param next
     */
    @Deprecated
    public void addStatus(EncodedDataStatus next) {
        EncodedDataStatus dataStatus2 = this;
        while (dataStatus2.nextStatus != null) {
            dataStatus2 = dataStatus2.nextStatus;
        }
        dataStatus2.nextStatus = next;
    }

    /**
     * links another status next to this one (for sending a batch of status
     * in a single message)
     * @param next
     */
    @Deprecated
    public void setNext(EncodedDataStatus next) {
        nextStatus = next;
    }
    
    /**
     * Static method that adds a new EncodedDataStatus(timestamp, name, value) to the current parameter.
     * @param current The Status we want to add data to (can be null)
     * @param timeStamp
     * @param name
     * @param value
     * @return 
     */
    @Deprecated
    public static EncodedDataStatus addData(EncodedDataStatus current, long timeStamp, String name, Object value){
        EncodedDataStatus res = new EncodedDataStatus(timeStamp, name, value);
        res.setNext(current);
        current = res;
        return res;
    }

    @Override
    public KeyValueDataList getEncodedData() {
        return EncodingUtils.encodeObject(this, this);
    }

    

    /**
     * helps iterating over a list of linked status message.
     * <P/>
     * So an idiom to read a message can be:
     * <PRE>
     *     EncodedDataStatus received = ..... ;
     *     for (EncodedDataStatus dataStatus : received) {
     *          KVList list = dataStatus.getContent();
     *          for (KeyData keyData : list) {
     *               .... dataStatus.getDataTimestamp() ....
     *              .... keyData.getKey() ....
     *              // one of those Three options
     *              .... keyData.getValue() .... // Optional
     *              .... keyData.getContentAsList() ....// may be empty
     *              .... keyData.getCrystallizedData() .... // Optional
     *          }
     *      }
     * </PRE>
     * @return
     */
    @Override
    public Iterator<EncodedDataStatus> iterator() {
        return new Iterator<EncodedDataStatus>() {

            EncodedDataStatus coming = EncodedDataStatus.this;

            @Override
            public boolean hasNext() {
                return coming != null;
            }

            @Override
            public EncodedDataStatus next() {
                EncodedDataStatus res = coming;
                coming = res.nextStatus;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();

            }
        };
    }

    public String getKey() {
        return key;
    }

    @Deprecated
    public KVList getContent() {
        Object obj = getObject();
        if ( ! (obj instanceof KVList) ) {
            obj = new KVList(getKey(), obj);
        }
        return (KVList)obj;
    }

    @Deprecated
    public Object getEmbeddedObject() {
        return (Object) super.getObject(); //To change body of generated methods, choose Tools | Templates.
    }


    
    @Deprecated
    public long getDataTimestamp() {
        return this.dataTimeStamp;
    }

    @Override
    public String toString() {
        return super.toString() + " {" +
                "content=" + getObject() +
                ", dataTimeStamp=" + dataTimeStamp +
                "} ";
    }

    @Override
    protected KeyValueDataList encodeObject(Serializable obj) {
        return EncodingUtils.encodeObject(this, obj);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.nextStatus);
        hash = 67 * hash + (int) (this.dataTimeStamp ^ (this.dataTimeStamp >>> 32));
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final EncodedDataStatus other = (EncodedDataStatus) obj;
        if (!Objects.equals(this.nextStatus, other.nextStatus)) {
            return false;
        }
        if (this.dataTimeStamp != other.dataTimeStamp) {
            return false;
        }
        return true;
    }

    
}
