/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;

public class TestAlerts {
    public static Alert alert;
    public static Alert alert2;
    public static Alert customAlert;
    public static RaisedAlertHistory raisedAlert;
    public static RaisedAlertHistory raisedAlert2;
    public static RaisedAlertHistory raisedCustomAlert;
    public static RaisedAlertHistory raisedCustomAlert2;

    @BeforeClass
    public static void initializeTests() {
        alert = new Alert("001", "Some alert");
        customAlert = new CustomAlert();
        alert2 = new Alert("002", "Some alert");
        raisedAlert = new RaisedAlertHistory(alert);
        raisedAlert2 = new RaisedAlertHistory(alert2);
        raisedCustomAlert = new RaisedAlertHistory(customAlert);
        raisedCustomAlert2 = new RaisedAlertHistory(customAlert);
    }

    @Test
    public void testAlertsEquals() {
        Assert.assertTrue((boolean)alert.equals((Object)customAlert));
        Assert.assertTrue((!alert2.equals((Object)customAlert) ? 1 : 0) != 0);
        Assert.assertTrue((!alert2.equals((Object)alert) ? 1 : 0) != 0);
    }

    @Test
    public void testBasicContentOfRaisedAlerts() throws IOException {
        Assert.assertTrue((boolean)raisedAlert.getAlert().equals((Object)alert));
        Assert.assertTrue((boolean)raisedAlert.getAlert().equals((Object)customAlert));
        Assert.assertTrue((boolean)raisedCustomAlert.getAlert().equals((Object)alert));
        Assert.assertTrue((boolean)raisedCustomAlert.getAlert().equals((Object)customAlert));
    }

    @Test
    public void testFillingRaisedAlerts() {
        Assert.assertTrue((raisedAlert.getHighestAlertState() == AlertState.NOMINAL ? 1 : 0) != 0);
        raisedAlert.addAlertInstance(AlertState.WARNING);
        raisedAlert.addAlertInstance(AlertState.WARNING);
        raisedAlert.addAlertInstance(AlertState.WARNING);
        Assert.assertTrue((raisedAlert.getNumberOfInstances() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((raisedAlert.getHighestAlertState() == AlertState.WARNING ? 1 : 0) != 0);
        raisedAlert.addAlertInstance(AlertState.ALARM);
        raisedAlert.addAlertInstance(AlertState.WARNING);
        raisedAlert.addAlertInstance(AlertState.WARNING);
        long last = System.currentTimeMillis();
        raisedAlert.addAlertInstance(AlertState.WARNING, last);
        Assert.assertTrue((raisedAlert.getHighestAlertState() == AlertState.ALARM ? 1 : 0) != 0);
        Assert.assertTrue((raisedAlert.getNumberOfInstances() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((raisedAlert.getLatestAlertTimestamp() == last ? 1 : 0) != 0);
    }

    static class CustomAlert
    extends Alert {
        CustomAlert() {
            super("001", "Some other alert");
        }
    }
}

