package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * Base class for all status messages containing data that is private
 * to the sender Subsystem.
 * Because clients will not necessarily have the class definition for the embedded
 * object, this class relies on the encoding procedure of the embedded object.
 * 
 * @author LSST CCS Team
 * @param <T> Any Serializable class embedded in the StatusData
 */
//REVIEW: Make this final when EncodedDataStatus is removed
//REVIEW: The templated class T could be made of type KeyValueData after EncodedDataStatus is removed.
public class StatusSubsystemData<T extends Serializable> extends StatusData {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -4563038237209683823L;
    
    private final String key;


    /**
     * Build a StatusMessage from the provided Object.
     *
     * @param obj The Serializable object to be sent over the buses.
     * @param state The State of the Agent at the time the object is created.
     */
    public StatusSubsystemData(T obj, StateBundle state) {
        super(obj, state);
        if ( obj instanceof KeyValueData ) {
            key = ((KeyValueData)obj).getKey();
        } else {
            key = obj.getClass().getCanonicalName();
        }
    }
    
    /**
     * Get the Key of the embedded object.
     * If the embedded object is a KeyValueData, then the KeyValueData's key
     * is returned, otherwise the canonical name of the class of the embedded
     * object.
     * 
     * @return The key of the embedded object.
     */    
    public String getDataKey() {
        return key;        
    }

    /**
     * Get the embedded subsystem data.
     * 
     * @return The subsystem data embedded in this message.
     * 
     */
    public Object getSubsystemData() {
        return (Object)getObject();
    }
    
}
