package org.lsst.ccs.bus.messages;


import org.lsst.ccs.bus.states.StateBundle;

/**
 * A StatusChangeNotification for State changes.
 * This is an event driven message sent on the Status bus when a State change
 * occurs. It contains the new (current) state of the subsystem and the old one.
 * 
 * @author The LSST CCS Team
 */
//TODO Make this class final when StatusChangeNotification is removed.
public class StatusStateChangeNotification extends StateChangeNotification {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -947295728235721L;
    
    /**
     * Create a StatusStateChangeNotification object.
     * 
     * @param oldState The old state before the State change
     * @param newState The new state, i.e. the current Agent state.
     */
    public StatusStateChangeNotification(StateBundle oldState, StateBundle newState) {
        super(oldState, newState);
    }


    /**
     * Get the new state of the Agent.
     * @return The new state of the Agent.
     */
    public StateBundle getNewState() {
        return getState();
    }

    /**
     * Get the old state of the Agent.
     * @return The old state of the Agent.
     */
    public StateBundle getOldState() {
        return getObject();
    }
}
