package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.StateBundle;

/**
 * Heartbeat status message. 
 * It is published at regular intervals: it is the pulse
 * of an Agent. Not all agents publish a Heartbeat.
 * This message is meant to be very light weight. It does not provide any encoding.
 * All it contains is the broadcast interval in seconds so that agents listening
 * to the heartbeat can estimate when the next one is expected to be published.
 * 
 * @author The LSST CCS Team
 * 
 * TODO: make this class final when the deprecated HeartBeatStatus class is removed.
 */
public class StatusHeartBeat extends StatusMessage {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -982313329639921L;

    private final int statusBroadcastPeriod;
    
    public StatusHeartBeat(int statusBroadcastPeriod, StateBundle state){
        super(null, state);
        this.statusBroadcastPeriod=statusBroadcastPeriod;
    }
        
    public int getStatusBroadcastPeriod(){
        return statusBroadcastPeriod;
    }

    @Override
    protected KeyValueDataList encodeObject(Serializable obj) {
        return null;
    }
    
}
