package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.bus.utils.EncodingUtils;

/**
 * Base class for all status messages containing data that is meant to be
 * stored in the trending database.
 * The provided Serializable object is embedded within the StatusData object
 * and encoded into the corresponding DataList.
 * 
 * @author LSST CCS Team
 * @param <T> Any Serializable class embedded in the StatusData
 */
public class StatusData<T extends Serializable> extends StatusMessage<T,KeyValueDataList> {

    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -12962837209683823L;


    /**
     * Build a StatusMessage from the provided Object.
     *
     * @param obj The Serializable object to be sent over the buses.
     * @param state The State of the Agent at the time the object is created.
     */
    public StatusData(T obj, StateBundle state) {
        super(obj, state);
    }

    @Override
    protected KeyValueDataList encodeObject(T obj) {
        return EncodingUtils.encodeObject(this,obj);
    }

    @Override
    public KeyValueDataList getEncodedData() {
        return super.getEncodedData();
    }

}
