package org.lsst.ccs.bus.data;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

/**
 * A Class to capture the Health of the running process.
 * 
 * @author The LSST CCS Team
 * 
 */
//TODO: Make this class final when corresponding class in org.lsst.ccs.bus.messages is removed
public class RuntimeInfo implements Serializable {
    
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = -72154637904826248L;
    
    public final int nThreads;
    public final long maxMemory = Runtime.getRuntime().maxMemory();
    public final long totalMemory, freeMemory;
    public final double processCpuLoad, systemCpuLoad;
    public transient static OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    public transient static Runtime runtime = Runtime.getRuntime();

    public RuntimeInfo() {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();        
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
    }

    public int getNThreads() {
        return nThreads;
    }

    public long getMaxMemory() {
        return maxMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public double getProcessCpuLoad() {
        return processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return systemCpuLoad;
    }

}
