package org.lsst.ccs.bus.data;

import java.io.Serializable;

/**
 * Represents the state of a given parameter.
 * @author The LSST CCS Team
 */
public class ConfigurationParameterInfo implements Serializable {
    /**
     * Change when backward incompatible changes are made.
     */
    private static final long serialVersionUID = 349573647834684384L;
    
    private String pathName;
    private String categoryName;
    private String defaultValue;
    private String configuredValue;
    private String currentValue;
    private boolean dirty;
    
    public ConfigurationParameterInfo(String pathName, String categoryName, String defaultValue, String configuredValue, String currentValue, boolean dirty){
        this.pathName= pathName;
        this.categoryName = categoryName;
        this.defaultValue = defaultValue;
        this.configuredValue = configuredValue;
        this.currentValue = currentValue;
        this.dirty = dirty;
    }
    
    /**
     * The Path name of the parameter.
     * e.g : "main//TickMillis"
     * @return a String representation of the path name
     */
    public String getPathName() {
        return pathName;
    }

    /**
     * The category the parameter belongs to.
     * @return the category the parameter represented by this object belongs to
     */
    public String getCategoryName() {
        return categoryName;
    }

    /**
     * The default value for this parameter, as specified in the groovy
     * description file.
     * @return a String representation of the default value.
     */
    public String getDefaultValue() {
        return defaultValue;
    }

    /**
     * The configured value for this parameter, i.e the value defined by the 
     * last configuration loading.
     * @return a String representation of the configured value.
     */
    public String getConfiguredValue() {
        return configuredValue;
    }

    /**
     * The current value for this parameter.
     * @return a String representation of the current value assigned to the parameter
     */
    public String getCurrentValue() {
        return currentValue;
    }

    /**
     * Boolean indicating if this parameter has been changed to a value and has 
     * not been saved yet.
     * @return True if the current value does not match the configured value.
     */
    public boolean isDirty() {
        return dirty;
    }

    @Override
    public String toString() {
        return "ConfigurationParameterInfo{" + "pathName=" + pathName + ", categoryName=" + categoryName 
                + ", defaultValue=" + defaultValue + ", configuredValue=" + configuredValue 
                + ", currentValue=" + currentValue + ", isDirty=" + dirty + '}';
    }
    
   
    
    
}
