/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.states;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.states.AlarmState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

public class TestStateBundle {
    @Test
    public void testBundleCreation() {
        StateBundle bundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING});
        Assert.assertTrue((boolean)bundle.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)bundle.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((!bundle.isInState((Enum)CommandState.READY) ? 1 : 0) != 0);
    }

    @Test
    public void testBundleMerge() {
        StateBundle bundle = new StateBundle(new Enum[]{OperationalState.ENGINEERING_FAULT, PhaseState.CLOSING});
        StateBundle bundle2 = new StateBundle(new Enum[]{OperationalState.NORMAL, CommandState.READY});
        StateBundle merge = bundle.mergeState(bundle2);
        merge.setState((Enum)AlarmState.NOMINAL);
        Assert.assertTrue((boolean)bundle.isInState((Enum)OperationalState.ENGINEERING_FAULT));
        Assert.assertTrue((boolean)bundle.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((!bundle.isInState((Enum)CommandState.READY) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)merge.isInState((Enum)OperationalState.NORMAL));
        Assert.assertTrue((boolean)merge.isInState((Enum)PhaseState.CLOSING));
        Assert.assertTrue((boolean)merge.isInState((Enum)CommandState.READY));
        Assert.assertTrue((boolean)merge.isInState((Enum)AlarmState.NOMINAL));
    }
}

