/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.Complex1;
import org.lsst.ccs.bus.messages.Complex2;
import org.lsst.ccs.bus.messages.Complex3;
import org.lsst.ccs.bus.messages.DistributionInfo;
import org.lsst.ccs.bus.messages.Enum1;
import org.lsst.ccs.bus.messages.HeartBeatStatus;
import org.lsst.ccs.bus.messages.KeyData;
import org.lsst.ccs.bus.messages.RuntimeInfo;
import org.lsst.ccs.bus.messages.SimpleChild;
import org.lsst.ccs.bus.messages.SimpleWithProps;
import org.lsst.ccs.bus.messages.StatusCodec;
import org.lsst.ccs.bus.messages.WithNullValue;
import org.lsst.ccs.bus.states.AlarmState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

public class TestStatusEncoding {
    @BeforeClass
    public static void prepareTest() {
        System.setProperty("org.lsst.ccs.project", "org-lsst-ccs-some-proj");
        System.setProperty("org.lsst.ccs.project.version", "1.8-SNAPSHOT");
        System.setProperty("org.lsst.ccs.jenkins.build.number", "23563");
        System.setProperty("org.lsst.ccs.jenkins.build.id", "adjks-3333 akskll   2");
        System.setProperty("org.lsst.ccs.jenkins.build.url", "http://srs.slac.stanford.edu/hudson?build=222");
        System.setProperty("org.lsst.ccs.jenkins.build.jdk", "1.8.0.34-p");
        System.setProperty("org.lsst.ccs.source.code.url", "svn+ssh://dev.lsstcorp.org/camera/CameraControl/some");
        System.setProperty("org.lsst.ccs.source.code.revision", "3432");
    }

    @AfterClass
    public static void clearTest() {
        System.setProperty("org.lsst.ccs.project.version", "");
        System.setProperty("org.lsst.ccs.jenkins.build.number", "");
        System.setProperty("org.lsst.ccs.jenkins.build.id", "");
        System.setProperty("org.lsst.ccs.jenkins.build.url", "");
        System.setProperty("org.lsst.ccs.jenkins.build.jdk", "");
        System.setProperty("org.lsst.ccs.source.code.url", "");
        System.setProperty("org.lsst.ccs.source.code.revision", "");
    }

    @Test
    public void testSimpleChildEncoding() throws Exception {
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        Object obj1 = StatusCodec.encode((Object)child);
        List list = StatusCodec.asSimpleKeyValueList((String)"clef", (Object)obj1);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("clef/name", (Object)"aSin"));
        toFind.add(new KeyData("clef/value", (Object)666));
        toFind.add(new KeyData("clef/valDouble", (Object)0.7));
        this.testEncodedLists(list, toFind);
        SimpleChild res = (SimpleChild)StatusCodec.decode((Object)obj1);
        Assert.assertEquals((Object)res, (Object)child);
    }

    @Test
    public void testComplex1ObjectEncoding() throws Exception {
        SimpleChild child = new SimpleChild("aSin", 666, 0.7);
        Complex1 complex1 = new Complex1(child, 966);
        Object obj2 = StatusCodec.encode((Object)complex1);
        List list2 = StatusCodec.asSimpleKeyValueList((String)"clef2", (Object)obj2);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("clef2/son/name", (Object)"aSin"));
        toFind.add(new KeyData("clef2/son/value", (Object)666));
        toFind.add(new KeyData("clef2/son/valDouble", (Object)0.7));
        toFind.add(new KeyData("clef2/id", (Object)966));
        this.testEncodedLists(list2, toFind);
        Complex1 res2 = (Complex1)StatusCodec.decode((Object)obj2);
        Assert.assertEquals((Object)res2, (Object)complex1);
    }

    @Test
    public void testComplex2ObjectEncoding() throws Exception {
        Complex2 complex2 = new Complex2(new BigDecimal("33.33"), 945);
        Object obj3 = StatusCodec.encode((Object)complex2);
        List list3 = StatusCodec.asSimpleKeyValueList((String)"clef3", (Object)obj3);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("clef3/value", (Object)new BigDecimal("33.33")));
        toFind.add(new KeyData("clef3/id", (Object)945));
        this.testEncodedLists(list3, toFind);
        Complex2 res3 = (Complex2)StatusCodec.decode((Object)obj3);
        Assert.assertEquals((Object)res3, (Object)complex2);
    }

    @Test
    public void testEnumerationEncoding() throws Exception {
        Object obj4 = StatusCodec.encode((Object)((Object)Enum1.MENEL));
        List list4 = StatusCodec.asSimpleKeyValueList((String)"enum1", (Object)obj4);
        Assert.assertTrue((list4.size() == 1 ? 1 : 0) != 0);
        KeyData d = (KeyData)list4.get(0);
        Assert.assertTrue((boolean)d.getKey().equals("enum1"));
        String e = (String)d.getValue().get();
        Assert.assertTrue((boolean)e.equals("MENEL"));
        Enum1 res4 = (Enum1)((Object)StatusCodec.decode((Object)obj4));
        Assert.assertEquals((Object)((Object)res4), (Object)((Object)Enum1.MENEL));
    }

    @Test
    public void testComplex3ObjectEncoding() throws Exception {
        Complex3 c3 = new Complex3(55, Enum1.MENEL);
        Object obj5 = StatusCodec.encode((Object)c3);
        List list5 = StatusCodec.asSimpleKeyValueList((String)"cpx5", (Object)obj5);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("cpx5/val", (Object)55));
        toFind.add(new KeyData("cpx5/anEnum", (Object)"MENEL"));
        this.testEncodedLists(list5, toFind);
        Complex3 res5 = (Complex3)StatusCodec.decode((Object)obj5);
        Assert.assertEquals((Object)res5, (Object)c3);
    }

    @Test
    public void testNullValueEncoding() throws Exception {
        WithNullValue withNullValue = new WithNullValue();
        Object obj6 = StatusCodec.encode((Object)withNullValue);
        List list6 = StatusCodec.asSimpleKeyValueList((String)"null", (Object)obj6);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("null/name", null));
        toFind.add(new KeyData("null/value", (Object)0));
        this.testEncodedLists(list6, toFind);
        WithNullValue res6 = (WithNullValue)StatusCodec.decode((Object)obj6);
        Assert.assertEquals((Object)res6, (Object)withNullValue);
    }

    @Test
    public void testConstructorWithPropertiesEncoding() throws Exception {
        SimpleWithProps simpleProps = new SimpleWithProps(3, "abc");
        Object obj7 = StatusCodec.encode((Object)simpleProps);
        List list7 = StatusCodec.asSimpleKeyValueList((String)"d", (Object)obj7);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("d/valInt", (Object)3));
        toFind.add(new KeyData("d/valString", (Object)"abc"));
        this.testEncodedLists(list7, toFind);
        SimpleWithProps res7 = (SimpleWithProps)StatusCodec.decode((Object)obj7);
        Assert.assertEquals((Object)res7, (Object)simpleProps);
    }

    @Test
    public void testMapEncoding() throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("one", 1);
        map.put("another", new SimpleChild("child", 45, 2345.0));
        map.put("last", "done");
        Object obj = StatusCodec.encode(map);
        List list = StatusCodec.asSimpleKeyValueList((String)"map", (Object)obj);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("map/one", (Object)1));
        toFind.add(new KeyData("map/another/name", (Object)"child"));
        toFind.add(new KeyData("map/another/value", (Object)45));
        toFind.add(new KeyData("map/another/valDouble", (Object)2345.0));
        toFind.add(new KeyData("map/last", (Object)"done"));
        this.testEncodedLists(list, toFind);
        Map res = (Map)StatusCodec.decode((Object)obj);
        Assert.assertEquals((Object)res, map);
    }

    @Test
    public void testDistributionInfoEncoding() throws Exception {
        DistributionInfo distInfo = new DistributionInfo();
        Object obj = StatusCodec.encode((Object)distInfo);
        List list = StatusCodec.asSimpleKeyValueList((String)"distInfo", (Object)obj);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("distInfo/project", (Object)System.getProperty("org.lsst.ccs.project")));
        toFind.add(new KeyData("distInfo/version", (Object)System.getProperty("org.lsst.ccs.project.version")));
        toFind.add(new KeyData("distInfo/buildNumber", (Object)System.getProperty("org.lsst.ccs.jenkins.build.number")));
        toFind.add(new KeyData("distInfo/buildId", (Object)System.getProperty("org.lsst.ccs.jenkins.build.id")));
        toFind.add(new KeyData("distInfo/buildUrl", (Object)System.getProperty("org.lsst.ccs.jenkins.build.url")));
        toFind.add(new KeyData("distInfo/buildJdk", (Object)System.getProperty("org.lsst.ccs.jenkins.build.jdk")));
        toFind.add(new KeyData("distInfo/sourceCodeUrl", (Object)System.getProperty("org.lsst.ccs.source.code.url")));
        toFind.add(new KeyData("distInfo/sourceCodeRevision", (Object)System.getProperty("org.lsst.ccs.source.code.revision")));
        this.testEncodedLists(list, toFind);
        DistributionInfo res = (DistributionInfo)StatusCodec.decode((Object)obj);
        Assert.assertTrue((boolean)res.equals((Object)distInfo));
    }

    @Test
    public void testRuntimeInfoEncoding() throws Exception {
        RuntimeInfo runInfo = new RuntimeInfo();
        Object obj = StatusCodec.encode((Object)runInfo);
        List list = StatusCodec.asSimpleKeyValueList((String)"runtimeInfo", (Object)obj);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("runtimeInfo/nThreads", (Object)runInfo.getNThreads()));
        toFind.add(new KeyData("runtimeInfo/maxMemory", (Object)runInfo.getMaxMemory()));
        toFind.add(new KeyData("runtimeInfo/totalMemory", (Object)runInfo.getTotalMemory()));
        toFind.add(new KeyData("runtimeInfo/freeMemory", (Object)runInfo.getFreeMemory()));
        toFind.add(new KeyData("runtimeInfo/processCpuLoad", (Object)runInfo.getProcessCpuLoad()));
        toFind.add(new KeyData("runtimeInfo/systemCpuLoad", (Object)runInfo.getSystemCpuLoad()));
        this.testEncodedLists(list, toFind);
        RuntimeInfo res = (RuntimeInfo)StatusCodec.decode((Object)obj);
        Assert.assertTrue((boolean)res.equals((Object)runInfo));
    }

    @Test
    public void testStateBundleEncoding() throws Exception {
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setState((Enum)PhaseState.CLOSING);
        sb.setState((Enum)PhaseState.INITIALIZING);
        sb.setState((Enum)OperationalState.ENGINEERING_FAULT);
        sb.setState((Enum)AlarmState.NOMINAL);
        Object obj = StatusCodec.encode((Object)sb);
        List list = StatusCodec.asSimpleKeyValueList((String)"stateBundle", (Object)obj);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("stateBundle/allStates/PhaseState", (Object)"INITIALIZING"));
        toFind.add(new KeyData("stateBundle/allStates/OperationalState", (Object)"ENGINEERING_FAULT"));
        toFind.add(new KeyData("stateBundle/allStates/AlarmState", (Object)"NOMINAL"));
        this.testEncodedLists(list, toFind);
        StateBundle res = (StateBundle)StatusCodec.decode((Object)obj);
        Assert.assertEquals((Object)res, (Object)sb);
    }

    @Test
    public void testAgentInfoEncoding() throws Exception {
        AgentInfo ai = new AgentInfo("a1", AgentInfo.AgentType.LISTENER);
        Object obj = StatusCodec.encode((Object)ai);
        List list = StatusCodec.asSimpleKeyValueList((String)"ai", (Object)obj);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("ai/name", (Object)"a1"));
        toFind.add(new KeyData("ai/type", (Object)"LISTENER"));
        this.testEncodedLists(list, toFind);
        AgentInfo res = (AgentInfo)StatusCodec.decode((Object)obj);
        Assert.assertEquals((Object)res, (Object)ai);
    }

    @Test
    public void testHeartBeatEncoding() throws Exception {
        HeartBeatStatus hb = new HeartBeatStatus(2);
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setState((Enum)PhaseState.INITIALIZING);
        sb.setState((Enum)OperationalState.ENGINEERING_FAULT);
        sb.setState((Enum)AlarmState.NOMINAL);
        hb.setState(sb);
        AgentInfo ai = new AgentInfo("someName", AgentInfo.AgentType.CONSOLE);
        hb.setOriginAgentInfo(ai);
        ArrayList<KeyData> toFind = new ArrayList<KeyData>();
        toFind.add(new KeyData("hb/state/allStates/PhaseState", (Object)"INITIALIZING"));
        toFind.add(new KeyData("hb/state/allStates/OperationalState", (Object)"ENGINEERING_FAULT"));
        toFind.add(new KeyData("hb/state/allStates/AlarmState", (Object)"NOMINAL"));
        RuntimeInfo runInfo = hb.getRuntimeInfo();
        toFind.add(new KeyData("hb/runtimeInfo/nThreads", (Object)runInfo.getNThreads()));
        toFind.add(new KeyData("hb/runtimeInfo/maxMemory", (Object)runInfo.getMaxMemory()));
        toFind.add(new KeyData("hb/runtimeInfo/totalMemory", (Object)runInfo.getTotalMemory()));
        toFind.add(new KeyData("hb/runtimeInfo/freeMemory", (Object)runInfo.getFreeMemory()));
        toFind.add(new KeyData("hb/runtimeInfo/processCpuLoad", (Object)runInfo.getProcessCpuLoad()));
        toFind.add(new KeyData("hb/runtimeInfo/systemCpuLoad", (Object)runInfo.getSystemCpuLoad()));
        toFind.add(new KeyData("hb/distributionInfo/project", (Object)System.getProperty("org.lsst.ccs.project")));
        toFind.add(new KeyData("hb/distributionInfo/version", (Object)System.getProperty("org.lsst.ccs.project.version")));
        toFind.add(new KeyData("hb/distributionInfo/buildNumber", (Object)System.getProperty("org.lsst.ccs.jenkins.build.number")));
        toFind.add(new KeyData("hb/distributionInfo/buildId", (Object)System.getProperty("org.lsst.ccs.jenkins.build.id")));
        toFind.add(new KeyData("hb/distributionInfo/buildUrl", (Object)System.getProperty("org.lsst.ccs.jenkins.build.url")));
        toFind.add(new KeyData("hb/distributionInfo/buildJdk", (Object)System.getProperty("org.lsst.ccs.jenkins.build.jdk")));
        toFind.add(new KeyData("hb/distributionInfo/sourceCodeUrl", (Object)System.getProperty("org.lsst.ccs.source.code.url")));
        toFind.add(new KeyData("hb/distributionInfo/sourceCodeRevision", (Object)System.getProperty("org.lsst.ccs.source.code.revision")));
        toFind.add(new KeyData("hb/summary", null));
        toFind.add(new KeyData("hb/originAgentInfo/name", (Object)"someName"));
        toFind.add(new KeyData("hb/originAgentInfo/type", (Object)"CONSOLE"));
        toFind.add(new KeyData("hb/timeStamp", (Object)hb.getTimeStamp()));
        toFind.add(new KeyData("hb/statusBroadcastPeriod", (Object)hb.getStatusBroadcastPeriod()));
        Object obj = StatusCodec.encode((Object)hb);
        List list = StatusCodec.asSimpleKeyValueList((String)"hb", (Object)obj);
        this.testEncodedLists(list, toFind);
        HeartBeatStatus res = (HeartBeatStatus)StatusCodec.decode((Object)obj);
        Assert.assertEquals((Object)res, (Object)hb);
    }

    private void testEncodedLists(List<KeyData> list, List<KeyData> toFind) {
        Assert.assertTrue((list.size() == toFind.size() ? 1 : 0) != 0);
        for (KeyData data : list) {
            KeyData found = null;
            String key = data.getKey();
            for (KeyData orig : toFind) {
                if (!orig.getKey().equals(key)) continue;
                Assert.assertEquals((Object)orig.getValue(), (Object)data.getValue());
                found = orig;
                break;
            }
            toFind.remove(found);
        }
        Assert.assertTrue((boolean)toFind.isEmpty());
    }
}

