package org.lsst.ccs.bus.messages;

import java.util.Objects;
import org.lsst.ccs.bus.states.StateBundle;


/**
 * Message to be sent on the Status Bus.
 * Currently all Status messages contain an object that describes the internal
 * state of the Agent from which the Status came from at the moment of the 
 * MessageStatus publication.
 * 
 * @author LSST CCS Team
 */
public class StatusMessage extends BusMessage {
    
    protected StateBundle state;
        
    /**
     * Set the StateBundle object containing the Agent's internal state at 
     * the moment the StatusMessage was published.
     * 
     * @param state The StateBundle object.
     * 
     */
    public void setState(StateBundle state){
        this.state = state;
    }
    
    /**
     * Get the PublishedState object that contains the Agent's internal state
     * at the moment the StatusMessage was published.
     * 
     * @return The StateBundle object.
     */
    public StateBundle getState(){
        return state;
    }
    
    @Override
    public String toString() {
        String sOrigin = getOriginAgentInfo() != null ? getOriginAgentInfo().getName() : "notSet";
        String s = getSummary();
        return getClass().getSimpleName() + "(" + sOrigin + ") @" + getTimeStamp() + " : [" + state + "] "
                + (s!=null? s:"");
    }

    @Override
    public int hashCode() {
        int hash = 7;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final StatusMessage other = (StatusMessage) obj;
        if (!Objects.equals(this.state, other.state)) {
            return false;
        }
        if ( !super.equals(obj) ) {
            return false;
        }
        return true;
    }

    
    
}
