package org.lsst.ccs.bus.messages;

/**
 * Message to be sent on the Command Bus.
 * @author LSST CCS Team
 */
public abstract class CommandMessage extends BusMessage {
    
    private String destination, correlationId;
    
    public CommandMessage(String destination, String correlationId) {
        this.destination = destination;
        this.correlationId = correlationId;                
    }
    
    public CommandMessage(String destination) {
        this(destination,java.util.UUID.randomUUID().toString());                
    }
    
    /**
     * The destination of the CommandMessage.
     * This is the name of the CCS Agent on the buses that is the target of this
     * CommandMessage.
     * 
     * @return The destination for this CommandMessage
     */
    public String getDestination(){
        return destination;
    }
    
    /**
     * The correlationId of this CommandMessage. The correlationId is a unique
     * identifier used to correlate CommandMessages related to the same command
     * exchange, as described in the Command State Diagram: WHICH URL?
     * The CorrelationId is intended to be used by CommandMessageListeners to
     * correlate messages.
     * The CorrelationId is used internally to route CommandReply messages to the
     * appropriate CommandOriginator
     * 
     * @return The Correlation Id for this message
     */
    public String getCorrelId(){
        return correlationId;
    }
    
}
