package org.lsst.ccs.bus.definition;

import java.io.Serializable;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * Bus definitions.
 *
 * @param <T>
 * @ImplSpec It is important that this list can be extended (for instance by
 * creating an Event bus)
 * @ImplNote Since there is no such thing as a parameterized enum, this class
 * emulates one: it lists the possible bus topics.
 */
//TODO: why Serializable?
public class Bus<T extends BusMessage> implements Serializable {

	public static final Bus<LogMessage> LOG = new Bus<>("LOG", 0);
	public static final Bus<StatusMessage> STATUS = new Bus<>("STATUS", 1);
	public static final Bus<CommandMessage> COMMAND = new Bus<>("COMMAND", 2);
	private static final Bus[] vals = {LOG, STATUS, COMMAND};
	private static final long serialVersionUID = -5478704370712583354L;

	private final String name;
	private final int ordinal;

	private Bus(String name, int ordinal) {
		this.name = name;
		this.ordinal = ordinal;
	}

        @Override
	public String toString() {
		return this.name;
	}

	public int ordinal() {
		return this.ordinal;
	}

	/***
	 * emulates the <TT>valueOf</TT> method of enums
	 * @param str
	 * @return 
	 */
	public static Bus valueOf(String str) {
		// should be a switch but is realised as a 1.6 compatible code
		String upperStr = str != null ? str.toUpperCase() : str;
		switch (upperStr) {
			case "COMMAND":
				return COMMAND;
			case "STATUS":
				return STATUS;
			case "LOG":
				return LOG;
			default:
				throw new IllegalArgumentException(str);

		}
	}

	/***
	 * emulates the <TT>values</TT> method of enums
	 */
	public static Bus[] values() {
		return vals;
	}
}
