/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.lsst.ccs.bus.messages.StatusCodec;
import org.lsst.ccs.utilities.logging.Logger;

public class KeyData
implements Serializable {
    public static Logger logger = Logger.getLogger((String)"org.lsst.ccs.bus");
    private final String key;
    private final Object data;

    KeyData(String key, Object data) {
        this.key = key;
        this.data = data;
    }

    public String getKey() {
        return this.key;
    }

    public List<KeyData> getContentAsList() {
        return StatusCodec.asSimpleKeyValueList(this.key, this.data);
    }

    public Optional<Object> getValue() {
        Object obj = null;
        try {
            obj = StatusCodec.decode(this.data);
        }
        catch (Exception e) {
            logger.warn((Object)("can't decode " + this.getKey()), (Throwable)e);
        }
        if (obj == null) {
            return Optional.empty();
        }
        return Optional.of(obj);
    }

    public Optional<byte[]> getCrystallizedData() {
        byte[] res = null;
        if (this.data instanceof StatusCodec.CodedData) {
            StatusCodec.CodedData obj = (StatusCodec.CodedData)this.data;
            if (obj.content instanceof byte[]) {
                res = (byte[])obj.content;
            }
        }
        return Optional.ofNullable(res);
    }

    public String getUpdatedKey(String globalName) {
        if (this.key.length() == 0) {
            return globalName;
        }
        return String.valueOf(globalName) + '/' + this.key;
    }

    public Object getRawValue() {
        return this.data;
    }

    public String toString() {
        return "{key='" + this.key + '\'' + ", data=" + this.data + '}';
    }
}

