package org.lsst.ccs.bus.states;

/**
 * The Phase State Diagram reflects the stages of an Agent's life cycle, from when it
 * starts to when it shuts down.
 * 
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * @author The LSST CCS Team
 */
public enum PhaseState {

    /**
     * When an Agent starts up it goes immediately in INITIALIZING state.
     * At this point all the hardware is initialized.
     * If there is any problem with the Agent's initialization, the Phase state
     * will remain INITIALIZING and the Operational State will be ENGINEERING_FAILURE.
     * If the initialization is successful the Phase state will become OPERATIONAL
     * and the Operational State will be ENGINEERING_OK.
     * 
     * 
     */
    INITIALIZING,
    
    /**
     * An Agent that has been successfully initialized will run in Phase OPERATIONAL.
     * If the Operational state is ENGINEERING_OK, then all is working properly for the Agent.
     * If, after a successful initialization, there is a problem with the hardware, the 
     * Phase state will remain OPERATIONAL and the Operational state will migrate to 
     * ENGINEERING_FAILURE.
     * 
     */
    OPERATIONAL,

    /**
     * Anytime a shutdown command is received by the Agent, it will go into CLOSING
     * state and proceed to shutdown any attached hardware component (if present).
     * If anything goes wrong during the shutdown process, the Phase state will remain
     * CLOSING and the Agent will go into ENGINEERING_FAILURE.
     * If all goes well, the Phase state will become OFF_LINE.
     * 
     */
    CLOSING,

    /**
     * The OFF_LINE state is reached upon successful shutdown.
     * This state is published right before the JVM is terminated.
     * 
     */
    OFF_LINE;
}
