package org.lsst.ccs.bus.states;

/**
 * State elements that deal with command execution.
 * 
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * @author The LSST CCS Team
 * 
 */
public enum CommandState {

    /**
     * The READY state is the initial state of an Agent and signifies that
     * the Agent is ready to receive any commands (including actions).
     * Query commands will not change the CommandState. The CommandState is only
     * changed by Action type commands.
     * 
     */
    READY,
    
    /**
     * Upon receipt of an Action type command, the Agent will internally migrate
     * to the ALMOST_ACTIVE state while it decides if the command is accepted or rejected.
     * If the command is rejected, it will go back to the READY state. If
     * the command is accepted, it will move into ACTIVE state.
     * This state is never published.
     * 
     */
    ALMOST_ACTIVE,
    
    /**
     * When an Agent is busy executing an Action type command it will be in
     * ACTIVE state. Upon completion of the command execution the state will 
     * go back to READY.
     * 
     */
    ACTIVE;

}
