package org.lsst.ccs.bus.states;

/**
 * The Alarm State of an Agent reflects how the hardware measured quantities
 * compare to their operational limits.
 * The Alarm State is, at any point, the level of the highest active existing alarm.
 * 
 * The Agent State Diagrams can be viewed at https://confluence.slac.stanford.edu/display/LSSTCAM/State+Diagrams
 * @author The LSST CCS Team
 */

public enum AlarmState {

    /**
     * An Agent is in the NOMINAL state when all is well with the connected hardware.
     * 
     */
    NOMINAL,
    
    /**
     * The Alarm state is WARNING when there is at least one active warning,
     * but no alarm level ones.
     * 
     */
    WARNING,
    
    /**
     * The Alarm state goes into ALARM when there is at least one active alarm.
     * 
     */
    ALARM;
}
