
package org.lsst.ccs.bus.messages;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

/**
 * A Class to capture the Health of the running process.
 * 
 * @author The LSST CCS Team
 * 
 */
public class RuntimeInfo implements Serializable {
    
    public final int nThreads;
    public final long maxMemory = Runtime.getRuntime().maxMemory();
    public final long totalMemory, freeMemory;
    public final double processCpuLoad, systemCpuLoad;
    public static OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    public static Runtime runtime = Runtime.getRuntime();

    public RuntimeInfo() {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();        
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
    }

    public int getNThreads() {
        return nThreads;
    }

    public long getMaxMemory() {
        return maxMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public double getProcessCpuLoad() {
        return processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return systemCpuLoad;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final RuntimeInfo other = (RuntimeInfo) obj;
        if (this.nThreads != other.nThreads) {
            return false;
        }
        if (this.maxMemory != other.maxMemory) {
            return false;
        }
        if (this.totalMemory != other.totalMemory) {
            return false;
        }
        if (this.freeMemory != other.freeMemory) {
            return false;
        }
        if (Double.doubleToLongBits(this.processCpuLoad) != Double.doubleToLongBits(other.processCpuLoad)) {
            return false;
        }
        if (Double.doubleToLongBits(this.systemCpuLoad) != Double.doubleToLongBits(other.systemCpuLoad)) {
            return false;
        }
        return true;
    }
    
    
    
}
