package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * A special status publishing a name/value pair on the status bus
 * 
 * @author aubourg
 * 
 */

public class MetadataStatus extends StatusMessage {

    private static final long serialVersionUID = -8878607893691562307L;
    private String dataName, metadataName, metadataValue;
    
	public MetadataStatus(String dataName, String metadataName, String metadataValue) {
            this(dataName,metadataName,metadataValue,System.currentTimeMillis());
	}
	public MetadataStatus(String dataName, String metadataName, String metadataValue, long timestamp) {
            super();
            this.dataName = dataName;
            this.metadataName = metadataName;
            this.metadataValue = metadataValue;
//            setTimeStamp(timestamp);
	}

	public String getDataName() {
		return dataName;
	}
	public String getMetadataName() {
		return metadataName;
	}
	public String getMetadataValue() {
		return metadataValue;
	}

	@Override
	public String toString() {
		return "MetadataStatus(" + getOriginAgentInfo().getName()+ ") @" + getTimeStamp() + " : [" + state + "] "
				+ getSummary() + "("+getDataName()+" "+getMetadataName()+" "+getMetadataValue()+")";                
	}

}
