package org.lsst.ccs.bus.messages;


/**
 * Command Ack.
 * Returned when a CommandRequest has been accepted and the recipient will carry
 * out the corresponding execution.
 * 
 * @author LSST CCS Team
 */
public class CommandAck extends CommandReply {

    private static final long serialVersionUID = -5603422495415777347L;

    public CommandAck(CommandRequest command, String commandOriginatorId) {
        this(command, null,commandOriginatorId);
    }

    public CommandAck(CommandRequest command, Object reply, String commandOriginatorId) {
        super(command, reply,commandOriginatorId);
    }

    @Override
    public String toString() {
        String origin = getOriginAgentInfo() != null ? getOriginAgentInfo().getName() : "notSet";
        return getClass().getName() + "(from " + origin + ")";
    }

}
