
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Utility class that encapsulates all the versions of the Agents on the
 * CCS Environment
 * 
 * @author The LSST CCS Team
 * 
 */
public class CCSVersions implements Serializable {
    
    private final Map<AgentInfo,DistributionInfo> map = new HashMap<>();
    
    /**
     * Add a new AgentInfo, DistributionInfo pair.
     * 
     * @param agent The AgentInfo
     * @param distInfo The DistributionInfo
     */
    public void add(AgentInfo agent, DistributionInfo distInfo) {
        map.put(agent, distInfo);
    }
    
    /**
     * Get the DistributionInfo for a given AgentInfo.
     * 
     * @param agent The AgentInfo for which to get the DistributionInfo.
     * @return The DistributionInfo for the provided AgentInfo.
     */
    public DistributionInfo getDistributionInfo(AgentInfo agent) {
        return map.get(agent);
    }
    
    /**
     * Get the DistributionInfo for a given agent by name.
     * 
     * @param agent The name of the for which to get the DistributionInfo.
     * @return The DistributionInfo for the provided AgentInfo.
     */
    public DistributionInfo getDistributionInfo(String agent) {
        for (AgentInfo a : map.keySet()) {
            if ( a.getName().equals(agent) ) {
                return map.get(a);
            }
        }
        return null;
    }
    
    /**
     * Get the Set of AgentInfo contained in this class.
     * 
     * @return The Set of AgentInfo contained in the class.
     */
    public Set<AgentInfo> getAgents() {
        return map.keySet();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AgentInfo a : getAgents() ) {
            sb.append("Agent "+a.getName()+"("+a.getType()+")\n");
            sb.append(getDistributionInfo(a).toString());
        }
        return sb.toString();
    }
    
    
}
