package org.lsst.ccs.bus.messages;


/**
 * Message to be sent on the Status Bus.
 * Currently all Status messages contain an object that describes the internal
 * state of the Agent from which the Status came from at the moment of the 
 * MessageStatus publication.
 * 
 * @author LSST CCS Team
 */
public class StatusMessage extends BusMessage {
    
    private static final long serialVersionUID = 5312244485551953004L;

    protected PublishedState state;
        
    /**
     * Set the PublishedState object containing the Agent's internal state at 
     * the moment the StatusMessage was published.
     * 
     * @param state The PublishedState object.
     * 
     */
    public void setState(PublishedState state){
        this.state = state;
    }
    
    /**
     * Get the PublishedState object that contains the Agent's internal state
     * at the moment the StatusMessage was published.
     * 
     * @return The PublishedState object.
     */
    public PublishedState getState(){
        return state;
    }
    
    @Override
    public String toString() {
        String sOrigin = getOriginAgentInfo() != null ? getOriginAgentInfo().getName() : "notSet";
        String s = getSummary();
        return getClass().getSimpleName() + "(" + sOrigin + ") @" + getTimeStamp() + " : [" + state + "] "
                + (s!=null? s:"");
    }

}
