package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * Represents a special status message for notifications of the end of execution of susbsystem with name/configuration/tag.
 * this message may be lost.
 * TODO: check if this is to be merged with normal heartBeat status
 * @author bamade
 */
// Date: 20/06/12

public class StatusForEnd extends StatusMessage  {
    private static final long serialVersionUID = -1905244484012474170L;
    private String configurationName ;
    private String tag ;
    boolean inTestContext ;

    public StatusForEnd(String configurationName, String tag) {
        this.configurationName = configurationName;
        this.tag = tag;
    }


    public String getConfigurationName() {
        return configurationName;
    }

     void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getTag() {
        return tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isInTestContext() {
        return inTestContext;
    }

    public void setInTestContext(boolean inTestContext) {
        this.inTestContext = inTestContext;
    }

    public String toString() {
        return super.toString() + " end for : " + configurationName + " " +tag ;
    }

}
