package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.messages.PublishedState;

import java.io.Serializable;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * @author bamade
 */
// Date: 23/01/2014

public class StateChangeNotification extends StatusMessage implements Serializable {
    private static final long serialVersionUID = -6140449952281306424L;
    private final PublishedState previousState;

    public StateChangeNotification(PublishedState oldState, PublishedState newState) {
        super();
        setState(newState);
        this.previousState = oldState;
    }

    public PublishedState getPreviousState() {
        return previousState;
    }
}
