package org.lsst.ccs.bus.messages;

import java.io.Serializable;

/**
 * Wrapper class for an Agent internal state.
 * When publishing any StatusMessage, the Agent's state is wrapped in a PublishedState
 * object that gets added to the StatusMessage
 * 
 * NOTE: Do we want to further define the Agent's internal state?
 * 
 * @author LSST CCS Team
 * @param <T> The internal state of the Agent.
 */

public class PublishedState<T extends Serializable> implements Serializable {

    private final T state;

    /**
     * Create a PublishedState object containing an Agent's internal state.
     * 
     * @param state The Agent's internal state.
     */
    public PublishedState(T state) {
        this.state = state;
    }

    /**
     * The the Agent's internal state contained in this object.
     * @return The original Agent internal state.
     * 
     */
    public T getState() {
        return state;
    }

    @Override
    public String toString() {
        return String.valueOf(state);
    }
}
