package org.lsst.ccs.bus.messages;

/**
 * The result of a CommandRequest.
 * The execution could be either successful or in error. This is reflected by
 * the status field AND by the returned Object. If in error an exception is returned.
 *
 * @author emarin
 */
public class CommandResult extends CommandReply {

    /**
     * Constructor for successful execution.
     * 
     * @param command The original CommandRequest. This is used for the correlation id.
     * @param reply   The result of the execution. It can be null.
     * @param commandOriginatorId
     */
    public CommandResult(CommandRequest command, Object reply, String commandOriginatorId) {
        super(command, reply,commandOriginatorId);
    }

    /**
     * Constructor for a CommandResult that produced an exception. The Exception is passed to the constructor as the reply.
     * 
     * @param command The original CommandRequest. This is used for the correlation id.
     * @param th      The Exception
     * @param commandOriginatorId
     */

    public CommandResult(CommandRequest command, Throwable th, String commandOriginatorId) {
        super(command, th, commandOriginatorId);
    }

    /**
     * Get the result of the CommandRequest execution.
     * If the CommandResultStatus of the execution is:
     *    - OK it will contain the object produced by the execution. It can be null.
     *    - ERROR it will contain the exception produced by the execution. It cannot be null.
     * 
     * @return The actual result of the execution. 
     */
    public Object getResult() {
        return getReply();
    }

    @Override
    public String toString() {
        return getClass().getName() + "(" + getResult() + " from "
                + getOriginAgentInfo() + ")";
    }

}
