package org.lsst.ccs.bus.messages;

/**
 * Base class for a command response.
 * Can be a CommandResult, CommandAck or CommandNack
 *
 * @author LSST CCS Team
 */
public class CommandReply extends CommandMessage {

    private final String commandOriginatorId;
    private final CommandRequest command;
    private final Object reply;
  
    
    public CommandReply(CommandRequest command, Object reply, String commandOriginatorId) {
        super(command.getOriginAgentInfo().getName(),command.getCorrelId());
        this.commandOriginatorId = commandOriginatorId;
        this.command = command;
        this.reply = reply;
    }
    
    public String getCommandOriginatorId() {
        return commandOriginatorId;
    }
    
    public CommandRequest getCommand() {
        return command;        
    }
    
    public Object getReply() {
        return reply;
    }
    
    
}
