package org.lsst.ccs.bus.messages;

/**
 * Command NACK.
 * Returned when a CommandRequest has been rejected and will not be carried out.
 * 
 * @author emarin
 */
public class CommandNack extends CommandReply {
    
    public CommandNack(CommandRequest command, Object reason, String commandOriginatorId) {
        super(command, reason,commandOriginatorId);
    }
    
    /**
     * The reason for the refusal.
     * DO WE NEED THIS? IF SO, SHOULD IT BE AN ENUMERATED RESULT?
     * 
     * @return The reason for rejecting a CommandRequest.
     */

    public String getReason() {
        if ( getReply() instanceof Exception ) {
            return ((Exception)getReply()).getMessage();
        }        
        return (String)getReply();
    }

            
}
