package org.lsst.ccs.bus.messages;

/**
 * Command Error.
 * Returned when a CommandRequest has been rejected and will not be carried out.
 * 
 * @author LSST CCS Team
 */
public class CommandError extends CommandReply {
    
    
    public CommandError(CommandRequest command, Throwable th, String commandOriginatorId) {
        super(command,th,commandOriginatorId);
    }
    
    
    /**
     * The reason for the refusal.
     * DO WE NEED THIS? IF SO, SHOULD IT BE AN ENUMERATED RESULT?
     * 
     * @return The reason for rejecting a CommandRequest.
     */

    public String getReason() {
        return ((Throwable) getReply()).toString();
    }

            
}
