package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.util.Objects;

/**
 * 
 * @author emarin
 */
public class AgentInfo implements Serializable {
    private final String name;
    private final AgentType type;

    public AgentInfo(String name, AgentType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public AgentType getType() {
        return type;
    }
    
    public static enum AgentType{
        LISTENER (0, "Listener"),
        CONSOLE (1, "Console"), 
        WORKER (2, "Worker"),
        SERVICE (3, "Service"),
        MCM (4,"MCM"),
        OCS_BRIDGE (5,"OCS bridge"),
        LOCK_MANAGER (6, "Lock manager");
        
        private final int id;
        private final String name;
                
        AgentType(int id, String name){
            this.name = name;
            this.id = id;
        }
        
        public int id() {return id;}
        public String displayName() {return name;}
        }
        
    public String toString(){
       return name + ":" + type;
    }
    
    @Override
    public boolean equals(Object a){
        if (!(a instanceof AgentInfo)) {
            return false;
        }
        else {
            AgentInfo agent = (AgentInfo)a;
            return getName().equals(agent.getName()) && getType().equals(agent.getType());
        }
        
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        hash = 89 * hash + Objects.hashCode(this.type);
        return hash;
    }
    
}
