
package org.lsst.ccs.bus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Utility class that encapsulates all the versions of the Agents on the
 * CCS Environment
 * 
 * @author The LSST CCS Team
 * 
 */
public class CCSVersions implements Serializable {
    
    private final Map<Agent,DistributionInfo> map = new HashMap<>();
    
    /**
     * Add a new Agent, DistributionInfo pair.
     * 
     * @param agent The Agent
     * @param distInfo The DistributionInfo
     */
    public void add(Agent agent, DistributionInfo distInfo) {
        map.put(agent, distInfo);
    }
    
    /**
     * Get the DistributionInfo for a given Agent.
     * 
     * @param agent The Agent for which to get the DistributionInfo.
     * @return The DistributionInfo for the provided Agent.
     */
    public DistributionInfo getDistributionInfo(Agent agent) {
        return map.get(agent);
    }
    
    /**
     * Get the DistributionInfo for a given agent by name.
     * 
     * @param agent The name of the for which to get the DistributionInfo.
     * @return The DistributionInfo for the provided Agent.
     */
    public DistributionInfo getDistributionInfo(String agent) {
        for (Agent a : map.keySet()) {
            if ( a.getName().equals(agent) ) {
                return map.get(a);
            }
        }
        return null;
    }
    
    /**
     * Get the Set of Agent contained in this class.
     * 
     * @return The Set of Agent contained in the class.
     */
    public Set<Agent> getAgents() {
        return map.keySet();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Agent a : getAgents() ) {
            sb.append("Agent "+a.getName()+"("+a.getType()+")\n");
            sb.append(getDistributionInfo(a).toString());
        }
        return sb.toString();
    }
    
    
}
