package org.lsst.ccs.bus;

/**
 * An alarm cleared message that can be sent on the status bus
 */

public class AlarmClear extends Status {
	/**
	 * 
	 */
	private static final long serialVersionUID = 2561719410661725416L;

	{
		detailLevel = DetailLevel.SEVERE;
		priorityLevel = PriorityLevel.OPERATION;
	}

	@Override
	public String getMessageType() {
		return "lsst.alarm";
	}

	@Override
	public String toString() {
		return "Alarm cleared @" + timeStamp + " : " + summary;
	}

}
