
package org.lsst.ccs.bus;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

/**
 * A Class to capture the Health of the running process.
 * 
 * @author The LSST CCS Team
 * 
 */
public class RuntimeInfo implements Serializable {
    
    public final int nThreads;
    public static final long maxMemory = Runtime.getRuntime().maxMemory();
    public final long totalMemory, freeMemory;
    public final double processCpuLoad, systemCpuLoad;
    public static OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    public static Runtime runtime = Runtime.getRuntime();

    public RuntimeInfo() {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();        
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
    }

    public int getnThreads() {
        return nThreads;
    }

    public static long getMaxMemory() {
        return maxMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public long getFreeMemory() {
        return freeMemory;
    }

    public double getProcessCpuLoad() {
        return processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return systemCpuLoad;
    }
    
    
    
}
