package org.lsst.ccs.bus;

import java.io.Serializable;
import java.util.HashMap;

/**
 * 
 * @author emarin
 */
public class HeartBeatStatus extends Status implements Serializable {

    private final int statusBroadcastPeriod;
    private final HashMap<Class, Serializable> innerObjects = new HashMap<>();
    private final RuntimeInfo runtimeInfo;
    private final DistributionInfo distributionInfo;
    
    
    public HeartBeatStatus(int statusBroadcastPeriod){
        this.statusBroadcastPeriod=statusBroadcastPeriod;
        this.runtimeInfo = new RuntimeInfo();
        this.distributionInfo = new DistributionInfo();
    }
        
    public int getStatusBroadcastPeriod(){
        return statusBroadcastPeriod;
    }
    
    public RuntimeInfo getRuntimeInfo() {
        return runtimeInfo;
    }
    
    public DistributionInfo getDistributionInfo() {
        return distributionInfo;
    }        
}
