package org.lsst.ccs.bus;

import java.io.Serializable;
import java.util.Objects;

/**
 * A Class to capture the information regarding this distribution.
 *
 * @author The LSST CCS Team
 *
 */
public class DistributionInfo implements Serializable {

    private final String project = System.getProperty("org.lsst.ccs.project", "");
    static String version = System.getProperty("org.lsst.ccs.project.version", "");
    static String buildNumber = System.getProperty("org.lsst.ccs.jenkins.build.number", "");
    static String buildId = System.getProperty("org.lsst.ccs.jenkins.build.id", "");
    static String buildUrl = System.getProperty("org.lsst.ccs.jenkins.build.url", "");
    static String buildJdk = System.getProperty("org.lsst.ccs.jenkins.build.jdk", "");
    static String sourceCodeUrl = System.getProperty("org.lsst.ccs.source.code.url", "");
    static String sourceCodeRevision = System.getProperty("org.lsst.ccs.source.code.revision", "");

    public String getProject() {
        return project;
    }

    public String getVersion() {
        return version;
    }

    public String getBuildNumber() {
        return buildNumber;
    }

    public String getBuildId() {
        return buildId;
    }

    public String getBuildUrl() {
        return buildUrl;
    }

    public String getBuildJdk() {
        return buildJdk;
    }

    public String getSourceCodeUrl() {
        return sourceCodeUrl;
    }

    public String getSourceCodeRevision() {
        return sourceCodeRevision;
    }
    @Override
    public int hashCode() {
        int hash = 7;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DistributionInfo other = (DistributionInfo) obj;
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.buildNumber, other.buildNumber)) {
            return false;
        }
        if (!Objects.equals(this.buildId, other.buildId)) {
            return false;
        }
        if (!Objects.equals(this.buildUrl, other.buildUrl)) {
            return false;
        }
        if (!Objects.equals(this.buildJdk, other.buildJdk)) {
            return false;
        }
        if (!Objects.equals(this.sourceCodeUrl, other.sourceCodeUrl)) {
            return false;
        }
        if (!Objects.equals(this.sourceCodeRevision, other.sourceCodeRevision)) {
            return false;
        }
        return true;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tProject        : ").append(project).append("\n");
        sb.append("\tProject Version: ").append(version).append("\n");
        sb.append("\tBuild Number   : ").append(buildNumber).append("\n");
        sb.append("\tBuild Id       : ").append(buildId).append("\n");
        sb.append("\tBuild Url      : ").append(buildUrl).append("\n");
        sb.append("\tBuild Jdk      : ").append(buildJdk).append("\n");
        sb.append("\tSource Code Rev: ").append(sourceCodeRevision).append("\n");
        sb.append("\tSource Code Url: ").append(sourceCodeUrl).append("\n");
        return sb.toString();        
    }
    

}
