package org.lsst.ccs.bus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * A special status publishing a name/value pair on the status bus
 * <P/>
 * Though it extends <TT>DataStatus_Deprecated</TT> the main purpose is slightly different.
 * 
 * @author aubourg
 * 
 */

public class TrendingStatus extends DataStatus_Deprecated {

    private static final long serialVersionUID = 6585487433733821541L;



	public TrendingStatus() {
	}

    //TODO: newer version will create an ObjectandType or DataValuelNotification
    @Deprecated
	public TrendingStatus(Object value) {
		super();
		this.value = value;
	}

    public TrendingStatus(DataValueNotification value) {
        super() ;
        this.value = value ;
    }

    public TrendingStatus(List<? extends ValueNotification> list) {
        super() ;
        this.value = list ;
        //System.out.println("calling TrendingStatus");
    }

    public String dummy() {
        return "dummy" ;
    }


    /**
     *  gets the content
     * @return
     */
    @Deprecated
	public Object getValue() {
        try {
            return getData();
        } catch (ClassNotFoundException e) {
            return value ;
        }
    }

    @Override
    public Object getData() throws ClassNotFoundException {
        //System.out.println("calling getData");
        if(value instanceof ObjectNType) {
            return ((ObjectNType) value).getData();
        }
        /* BUG
        if(value instanceof DataValueNotification) {
            return ((DataValueNotification)value).getRealData() ;
        }
        //TODO: reassess what to do
    if(value instanceof List) {
    if(((List)value).get(0) instanceof DataValueNotification) {
        List<DataValueNotification> listValues = (List<DataValueNotification>) value ;
        ArrayList<Object> res = new ArrayList<Object>(listValues.size()) ;
        for(DataValueNotification notification : listValues) {
            res.add(notification.getRealData()) ;
        }
        return res ;
            }
            if(((List)value).get(0) instanceof ValueNotification) {
                /*
                List<ValueNotification> listValues = (List<ValueNotification>) value ;
                ArrayList<Object> res = new ArrayList<Object>(listValues.size()) ;
                for(ValueNotification notification : listValues) {
                    res.add(notification.getData()) ;
                }
                return res ;
            }
        }
                */
        return value ;
    }

    /**
     * Map of Trending key/values: the values are itself of type
     * <TT>ObjectNType</TT> so you can get the real type to be used.
     * if the content is a list of <TT>DataValueNotification</TT> all trending info
     * is added to the same Map.
     * @returna may be null if content is not based on <TT>DataValueNotification</TT>
     */
    public Map<String, ObjectNType> getTrendingMap() {
        if(value instanceof DataValueNotification) {
            return ((DataValueNotification)value).getTrendingMap() ;
        } else if (value instanceof List) {
            // we only accept DataValue Notification as members of the list
            HashMap<String,ObjectNType> mapres = new HashMap<String, ObjectNType>() ;
            for(Object member : (List) value) {
                if(! (member instanceof DataValueNotification)) {
                    //TODO LOG WARNING!
                    return null ;
                }
                Map<String, ObjectNType> mapDVN = ((DataValueNotification)member).getTrendingMap() ;
                if(mapDVN != null) {
                    mapres.putAll(mapDVN);
                }
            }
            return mapres ;
        }
        return null ;
    }

    @Deprecated
	public void setValue(Object value) {
		this.value = value;
	}

    @Override
    public boolean isOfWellKnownType() {
        if(value instanceof ObjectNType) {
            return ((ObjectNType) value).isOfWellKnownType();
        }
        if(value instanceof DataValueNotification) {
            return ((DataValueNotification)value).isOfWellKnownType() ;
        }
        //TODO : is this true?
        if(value instanceof List) {
            return false ;
        }
        return true ;
    }

    @Override
    public boolean  isOfPrimitiveType() {
        if(value instanceof ObjectNType) {
            return ((ObjectNType) value).isOfPrimitiveType();
        }
        if(value instanceof DataValueNotification) {
            return ((DataValueNotification)value).isOfPrimitiveType() ;
        }
        return false ;
    }
    @Override
    public String getDataClassName() {
        if(value instanceof DataValueNotification) {
            return ((DataValueNotification)value).getObjectNType().getClassName() ;
        }
        return super.getDataClassName() ;
    }

	@Override
	public String toString() {
        Object val = null ;
        try {
            val = getData() ;
        } catch (ClassNotFoundException e) {
            val = "object_class_not_found" ;
        }
        return "TrendingStatus(" + origin + ") @" + timeStamp + " : [" + state + "] "
				+ summary+ "("+ val +")";
	}

}
