package org.lsst.ccs.bus;

import org.lsst.ccs.state.PublishedState;

import java.io.Serializable;

/**
 * @author bamade
 */
// Date: 23/01/2014

public class StateChangeNotification extends Status implements Serializable {
    private static final long serialVersionUID = -6140449952281306424L;
    private final PublishedState previousState;

    public StateChangeNotification(DetailLevel level, PublishedState oldState, PublishedState newState) {
        super();
        setState(newState);
        this.previousState = oldState;
        this.detailLevel = level;
    }

    public PublishedState getPreviousState() {
        return previousState;
    }
}
