package org.lsst.ccs.bus;

import java.io.Serializable;

/**
 * Logging event to be sent on logging bus.
 * Data is independent of Logging implementation and should be sent across
 * the buses to agent that do not have necessarily the same classes.
 * (for this reason we do not send objects of any kind including Throwables)
 *
 * @ImplNote
 * we create our own object with fields we control
 * with an API that enables us to send String information instead of Throwable
 * @author aubourg
 */

// TODO check metadata, what kind of object, and check with log4j interface that
// can accept Object messages

public class LogEvent extends BusMessage implements Serializable {

    private static final long serialVersionUID = -4194787513329636909L;

    private final String threadName;

    private final String loggerName;
    
    private final String sourceName;
    
    private final String formattedDetails;
    
    private final String level;

    /*
    // TODO Able to convert to/from log4j, and other systems should be possible
    public LogEvent(Object o) {
        obj = o;

        // TBD move log4j specific stuff back to the log4j bridge?
        if (o instanceof LoggingEvent) {
            LoggingEvent l4evt = (LoggingEvent) o;
            timeStamp = l4evt.timeStamp;
            summary = l4evt.getMessage().toString();
            Level l4jLev = l4evt.getLevel();
            if (l4jLev.equals(Level.DEBUG))
                detailLevel = DetailLevel.FINEST;
            else if (l4jLev.equals(Level.INFO))
                detailLevel = DetailLevel.INFO;
            else if (l4jLev.equals(Level.WARN))
                detailLevel = DetailLevel.WARNING;
            else if (l4jLev.equals(Level.ERROR))
                detailLevel = DetailLevel.SEVERE;
            else if (l5jLev.equals(Level.FATAL))
                detailLevel = DetailLevel.SEVERE;
            else
                detailLevel = DetailLevel.FINE;
        }
    }
    
    */

    /**
     *
     * @param threadName the name of the thread (important since Commands have a special name)
     * @param loggerName the name of the logger which issued the log
     * @param sourceName concatenation of the form ClassName#methodName
     * @param formattedDetails a formatted  String that represents the Log record (can be text or xml)
     *                         it is dependent on the <TT>Formatter</TT> of the Handler.
     * @param level A string representing the Level
     */
    public LogEvent(String threadName, String loggerName, String sourceName, String formattedDetails, String level) {
        this.threadName = threadName;
        this.loggerName = loggerName;
        this.sourceName = sourceName;
        this.formattedDetails = formattedDetails;
        this.level = level;
    }

    @Override
    public String getMessageType() {
        return "lsst.log";
    }

    
    
    public String getThreadName() {
        return threadName;
    }

    public String getLoggerName() {
        return loggerName;
    }

    public String getSourceName() {
        return sourceName;
    }

    public String getFormattedDetails() {
        return formattedDetails;
    }

    public String getLevel() {
        return level;
    }


    /**
     * returns the "formatted details"
     * @return
     */
    @Override
    public String toString() {
        return formattedDetails;
    }
}


   

