package org.lsst.ccs.bus;

import org.lsst.ccs.utilities.tracers.Tracer;

import java.io.Serializable;

/**
 * Generic abstract bus message class
 * 
 * Concrete implementations (command, status, logevent) will be sent on the
 * appropriate bus.
 * 
 * 
 * @author aubourg
 * 
 */

public abstract class BusMessage implements Serializable, BusPayload {
    static {
        assert Tracer.version("$Rev$", BusMessage.class, "org-lsst-ccs-buses-definition") ;
    }

    private static final long serialVersionUID = 5876509633029221141L;
	// @NotNull
	protected String origin;
	// @Nullable
	protected String summary;

	//TODO : ??? 
	protected DetailLevel detailLevel = DetailLevel.INFO;
	protected PriorityLevel priorityLevel = PriorityLevel.INFO;

	protected BusMessage(String origin) {
		this.origin = origin;
	}
	// use sparingly
	protected BusMessage() {
	}


	protected long timeStamp = System.currentTimeMillis();

	public abstract String getMessageType();
	/**
	 * the origin subsystem
	 */
	public String getOrigin() {
		return origin;
	}

	public void setOrigin(String origin) {
		this.origin = origin;
	}


	/**
	 * timestamp, in milliseconds since 1970
	 */
	public long getTimeStamp() {
		return timeStamp;
	}

	public void setTimeStamp(long timeStamp) {
		this.timeStamp = timeStamp;
	}


	/**
	 * a summary string
	 * 
	 * @return
	 */
	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}


	public DetailLevel getDetailLevel() {
		return detailLevel;
	}

	/**
	 * Sets the detail level.
	 * 
	 * Will impact for instance the retention duration of the message
	 */

	public void setDetailLevel(DetailLevel detailLevel) {
		this.detailLevel = detailLevel;
	}


	public PriorityLevel getPriorityLevel() {
		return priorityLevel;
	}

	/**
	 * Sets the priority level.
	 * 
	 * Will be translated into a transport layer priority
	 */

	public void setPriorityLevel(PriorityLevel priorityLevel) {
		this.priorityLevel = priorityLevel;
	}

}