package org.lsst.ccs.bus;

import java.io.Serializable;
import java.util.Objects;

/**
 * 
 * @author emarin
 */
public class Agent implements Serializable {
    private String name;
    private final AgentType type;

    public Agent(String name, AgentType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public AgentType getType() {
        return type;
    }
    
    // TODO : Remove when deprecated constructor of Subsystem is removed
    // TODO : Then make the name field final
    public void setName(String name){
        this.name = name;
    }
    
    public static enum AgentType{
        LISTENER (0, "Listener"),
        CONSOLE (1, "Console"), 
        WORKER (2, "Worker"),
        SERVICE (3, "Service"),
        MCM (4,"MCM"),
        OCS_BRIDGE (5,"OCS bridge"),
        LOCK_MANAGER (6, "Lock manager");
        
        private final int id;
        private final String name;
        
        AgentType(int id, String name){
            this.name = name;
            this.id = id;
        }
        
        public int id() {return id;}
        public String displayName() {return name;}
    }
    
    public String toString(){
       return name + ":" + type;
    }
    
    @Override
    public boolean equals(Object a){
        if (!(a instanceof Agent)) {
            return false;
        }
        else {
            Agent agent = (Agent)a;
            return getName().equals(agent.getName()) && getType().equals(agent.getType());
        }
        
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        hash = 89 * hash + Objects.hashCode(this.type);
        return hash;
    }
    
}
