/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.Serializable;
import org.lsst.ccs.bus.DataCapsule;

public class ObjectNType
implements Serializable {
    public static final Class[] WELL_KNOWN_TYPES = new Class[]{String.class, Number.class, byte[].class, int[].class, double[].class, String[].class};
    private static final long serialVersionUID = -4360711926765274975L;
    private final String className;
    private final boolean ofWellKnownType;
    private final boolean primitiveType;
    private final Object data;

    public ObjectNType(Class clazz, Serializable value) {
        if (value == null) {
            this.data = value;
            this.className = clazz != null ? clazz.getCanonicalName() : null;
            this.ofWellKnownType = true;
            this.primitiveType = true;
            return;
        }
        this.className = clazz.getCanonicalName();
        this.ofWellKnownType = ObjectNType.isWellKnownType(clazz);
        if (this.ofWellKnownType) {
            this.data = value;
            this.primitiveType = clazz.isPrimitive();
        } else {
            this.data = new DataCapsule(value);
            this.primitiveType = false;
        }
    }

    public ObjectNType(Serializable value) {
        this(value != null ? value.getClass() : null, value);
    }

    public ObjectNType(int value) {
        this(Integer.TYPE, Integer.valueOf(value));
    }

    public ObjectNType(long value) {
        this(Long.TYPE, Long.valueOf(value));
    }

    public ObjectNType(float value) {
        this(Float.TYPE, Float.valueOf(value));
    }

    public ObjectNType(double value) {
        this(Double.TYPE, Double.valueOf(value));
    }

    public ObjectNType(char value) {
        this(Character.TYPE, Character.valueOf(value));
    }

    public static boolean isWellKnownType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        Class[] classArray = WELL_KNOWN_TYPES;
        int n = WELL_KNOWN_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Class knownClass = classArray[n2];
            if (knownClass.isAssignableFrom(clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isOfPrimitiveType() {
        return this.primitiveType;
    }

    public boolean isOfWellKnownType() {
        return this.ofWellKnownType;
    }

    public Object getData() throws ClassNotFoundException {
        if (this.ofWellKnownType) {
            return this.data;
        }
        DataCapsule capsule = (DataCapsule)this.data;
        return capsule.getData();
    }

    public Object getRawData() {
        return this.data;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.data)) + (this.className != null ? " [" + this.className + "]" : "");
    }
}

