package org.lsst.ccs.bus;

/**
 * Represents a special status message for notifications of the end of execution of susbsystem with name/configuration/tag.
 * this message may be lost.
 * TODO: check if this is to be merged with normal heartBeat status
 * @author bamade
 */
// Date: 20/06/12

public class StatusForEnd extends Status  implements SubsystemToken{
    private static final long serialVersionUID = -1905244484012474170L;
    String configurationName ;
    String tag ;
    boolean inTestContext ;
    boolean master;
    boolean slave ;

    public StatusForEnd(String configurationName, String tag, boolean master, boolean slave) {
        this.configurationName = configurationName;
        this.tag = tag;
        this.master = master ;
        this.slave = slave ;
    }


    public String getConfigurationName() {
        return configurationName;
    }

     void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getTag() {
        return tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isInTestContext() {
        return inTestContext;
    }

    public void setInTestContext(boolean inTestContext) {
        this.inTestContext = inTestContext;
    }

    public String toString() {
        return super.toString() + " end for : " + configurationName + " " +tag ;
    }

    public boolean isMaster() {
        return master;
    }

    public boolean isSlave() {
        return slave;
    }
}
