package org.lsst.ccs.bus;

/**
 * An ack message to notify initiator of a command rejection.
 * This is different from a Response with an Exception
 * @author bamade
 */
// Date: 30/10/2013

public class NegativeAck extends CommandAck{
    private  String reason ;

    public NegativeAck(Command command, String origin, String reason) {
        super(command, origin);
        this.reason = reason;
    }

    public String getReason() {
        return reason;
    }

    public String toString() {
        return super.toString() + " [" + reason + "]" ;
    }
}
