package org.lsst.ccs.bus;

/**
 * Reply to command.
 *
 * 
 */
public class CommandReply extends CommandAckOrReply  {

    private static final long serialVersionUID = -8056794161035014352L;

    @Override
    public String getMessageType() {
        return "lsst.reply";
    }

    /**
     * @ImplSpec
     * this has been changed: previous status are transfered to Positive or Negative Ack.
     */
    public enum CommandStatus {
		OK,  OK_VOID, ERROR;
	};

	CommandStatus status;
	Object reply;

    // nolonger valid : serach information in Thread context or change class
    @Deprecated
	public CommandReply(Object reply, CommandStatus status) {
		super();
		this.reply = reply;
		this.status = status;
	}

    // added by bamade
    public CommandReply(Command command, Object reply, CommandStatus status, String origin) {
        super(command,origin);
        this.status = status;
        this.reply = reply;
    }
    public CommandReply(Command command,   String origin) {
        super(command,origin);
        this.status= CommandStatus.OK_VOID ;
    }

    public CommandReply(Command command,   Throwable th , String origin) {
        super(command,origin);
        this.status= CommandStatus.ERROR ;
        this.reply = th ;
    }

    /**
	 * @return the status
	 */
	public CommandStatus getStatus() {
		return status;
	}

	/**
	 * @return the reply
	 */
	public Object getReply() {
		return reply;
	}

	@Override
	public String toString() {
		return getClass().getName() + "(" + status + "/" + reply + " from "
				+ origin + ")";
	}
}
