package org.lsst.ccs.bus;

import java.io.Serializable;

/**
 * Bus definitions.
 *
 * @ImplSpec It is important that this list can be extended (for instance by
 * creating an Event bus)
 * @ImplNote Since there is no such thing as a parameterized enum, this class
 * emulates one: it lists the possible bus topics.
 */
//TODO: why Serializable?
public class Bus<T extends BusPayload> implements Serializable {

	public static final Bus<LogEvent> LOG = new Bus<LogEvent>("LOG", 0);
	public static final Bus<Status> STATUS = new Bus<Status>("STATUS", 1);
	public static final Bus<CommandBusMessage> COMMAND = new Bus<CommandBusMessage>("COMMAND", 2);
	private static final Bus[] vals = {LOG, STATUS, COMMAND};
	private static final long serialVersionUID = -5478704370712583354L;

	private String name;
	private int ordinal;

	private Bus(String name, int ordinal) {
		this.name = name;
		this.ordinal = ordinal;
	}

	public String toString() {
		return this.name;
	}

	public int ordinal() {
		return this.ordinal;
	}

	/***
	 * emulates the <TT>valueOf</TT> method of enums
	 * @param str
	 * @return 
	 */
	public static Bus valueOf(String str) {
		// should be a switch but is realised as a 1.6 compatible code
		String upperStr = str != null ? str.toUpperCase() : str;
		switch (upperStr) {
			case "COMMAND":
				return COMMAND;
			case "STATUS":
				return STATUS;
			case "LOG":
				return LOG;
			default:
				throw new IllegalArgumentException(str);

		}
	}

	/***
	 * emulates the <TT>values</TT> method of enums
	 */
	public static Bus[] values() {
		return vals;
	}
}
