/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.bus;

import java.io.Serializable;
import java.util.Objects;

/**
 * 
 * @author emarin
 */
public class Agent implements Serializable {
    private String name;
    private final AgentType type;

    public Agent(String name, AgentType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public AgentType getType() {
        return type;
    }
    
    // TODO : Remove when deprecated constructor of Subsystem is removed
    // TODO : Then make the name field final
    public void setName(String name){
        this.name = name;
    }
    
    public static enum AgentType{
        LISTENER,
        CONSOLE, 
        WORKER,
        SERVICE,
        MCM,
        OCS_BRIDGE,
        LOCK_MANAGER
    }
    
    public String toString(){
       return name + ":" + type;
    }
    
    @Override
    public boolean equals(Object a){
        if (!(a instanceof Agent)) {
            return false;
        }
        else {
            Agent agent = (Agent)a;
            return getName().equals(agent.getName()) && getType().equals(agent.getType());
        }
        
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        hash = 89 * hash + Objects.hashCode(this.type);
        return hash;
    }
    
}
