package org.lsst.ccs.bus;

import org.lsst.ccs.state.PublishedState;

import java.io.Serializable;

/**
 * A Status message that can be sent on the status bus
 *
 * @author aubourg
 */

//TODO: make abstract and move thos code to SubSystemStatus
public class Status extends BusMessage implements Serializable {

    private static final long serialVersionUID = 5312244485551953004L;

    protected PublishedState state;
    @Override
    public String getMessageType() {
        return "lsst.status";
    }

    //TODO: get rid of no-arg ctor!
    public Status() {

    }

    public Status(PublishedState state) {
        this.state = state;
    }


    public PublishedState getState() {
        return state;
    }

    public void setState(PublishedState state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "(" + origin + ") @" + timeStamp + " : [" + state + "] "
                + summary;
    }

}
