package org.lsst.ccs.bus;

import java.io.Serializable;

/**
 * This class contains information about an object and it class.
 * this information can be used in different ways:
 * <UL>
 *     <LI/> to store a primitive as an object (then is will be known for instance that the Object
 *     is not, for instance,  of type <TT>Integer</TT> but of type <TT>int</TT>;
 *     <LI/> to store a complex Object where the code that read may not have acces to the class.
 *     for this purpose the Object is "frozen" in a <TT>DataCapsule</TT>
 * </UL>
 * <P/>
 * Beware: the name of the class does not guarantees that the  "frozen" object can be deserialized
 * since the version of the class can differ.
 * @author bamade
 */
// Date: 05/04/13

public class ObjectNType implements Serializable {
    public static final Class[] WELL_KNOWN_TYPES = {
            //primitives are well known org.lsst.gruth.types
            String.class,
            Number.class,
            byte[].class,
            int[].class,
            double[].class,
            String[].class,
    };
    private static final long serialVersionUID = -4360711926765274975L;
    private final String className ;
    private final boolean ofWellKnownType;
    private final boolean primitiveType ;
    private final Object data ;

    /**
     * keeps an object in a serialization-safe manner.
     * @param clazz mostly used to note an object of a primitive type (e.g. Integer.TYPE)
     * @param value can be null
     */
    public ObjectNType(Class clazz, Serializable value)  {
        if (null == value) {
            this.data = value;
            this.className = (clazz!= null? clazz.getCanonicalName(): null) ;
            ofWellKnownType = true;
            primitiveType = true ;
            return;
        }
        this.className = clazz.getCanonicalName();
        ofWellKnownType = isWellKnownType(clazz) ;
        if(ofWellKnownType) {
            this.data = value ;
            primitiveType = clazz.isPrimitive() ;
        } else {
            this.data = new DataCapsule(value);
            primitiveType = false ;
        }
    }

    /**
     * general constructor to keep an object safely
     * @param value
     */
    public ObjectNType(Serializable value)  {
        this(value != null?value.getClass(): null, value) ;
    }

    public ObjectNType(int value) {
        this(Integer.TYPE, value) ;
    }
    public ObjectNType(long value) {
        this(Long.TYPE, value) ;
    }
    public ObjectNType(float value) {
        this(Float.TYPE, value) ;
    }
    public ObjectNType(double value) {
        this(Double.TYPE, value) ;
    }
    public ObjectNType(char value) {
        this(Character.TYPE, value) ;
    }


    /**
     * is the class a "well known type" (primitive or defined in the constant array WELL_KNOWN_TYPES)
     * @param clazz
     * @return
     */
    public static boolean isWellKnownType(Class clazz) {
        if(clazz.isPrimitive()) {
            return true;
        }
        for (Class knownClass : WELL_KNOWN_TYPES) {
            if (knownClass.isAssignableFrom(clazz)) {
                return true;
            }
        }
        return false ;
    }

    /**
     * the name of the class of the contained Object.
     * @return can be null!
     */
    //@Nullable
    public String getClassName() {
        return className;
    }

    /**
     * is the data to be considered of a primitive type
     * @return
     */
    public boolean isOfPrimitiveType() {
        return primitiveType;
    }

    /**
     * being of a "well known type" means that the data has not been "safely" Serialized
     * @return
     */
    public boolean isOfWellKnownType() {
        return ofWellKnownType;
    }

    /**
     * return the data contained in a safe way: if the class of the stored Object is not in the ClassPath
     * an Exception is thrown
     * @return
     * @throws ClassNotFoundException
     */
    public Object getData() throws ClassNotFoundException {
        if(ofWellKnownType) {
            return data;
        }
        DataCapsule capsule = (DataCapsule) data ;
        return capsule.getData() ;
    }

    /**
     * gets the content "as is" (without deserializing)
     * @return
     */
    public Object getRawData() {
        return data ;
    }

    public String toString() {
        return String.valueOf(data) + (className!= null? " ["+className+"]" : "") ;
    }
}
