package org.lsst.ccs.bus;

/**
 * A special status publishing a name/value pair on the status bus
 * 
 * @author aubourg
 * 
 */

public class MetadataStatus extends Status {

    private static final long serialVersionUID = -8878607893691562307L;
    private String dataName, metadataName, metadataValue;
    
	public MetadataStatus(String dataName, String metadataName, String metadataValue) {
            this(dataName,metadataName,metadataValue,System.currentTimeMillis());
	}
	public MetadataStatus(String dataName, String metadataName, String metadataValue, long timestamp) {
            super();
            this.dataName = dataName;
            this.metadataName = metadataName;
            this.metadataValue = metadataValue;
            setTimeStamp(timeStamp);
	}

	public String getDataName() {
		return dataName;
	}
	public String getMetadataName() {
		return metadataName;
	}
	public String getMetadataValue() {
		return metadataValue;
	}

	@Override
	public String toString() {
		return "MetadataStatus(" + origin + ") @" + timeStamp + " : [" + state + "] "
				+ summary+ "("+getDataName()+" "+getMetadataName()+" "+getMetadataValue()+")";                
	}

}
